-------------------------------Patrick et Eric

function form_bomb(name, user_name, model, level3, scheme, data, targeting_data, class_name, wstype_name)
	local wstype_name = wstype_name
	if  wstype_name == nil then
		wstype_name = _G[name]
	end
	
    local res = dbtype(class_name or "wAmmunition", 
    {
        ws_type = {wsType_Weapon,wsType_Bomb, level3, wstype_name},    
        model   = model,
    })
   
    data.fm.wind_time = 1000;
	
	data.fm.I = data.fm.I or calcIyz(data.fm.mass, data.fm.L, 0)
	data.fm.Ma = data.fm.Ma or calcMa(data.fm.I, data.fm.L, calcS(data.fm.caliber), 400)
	data.fm.Mw = data.fm.Mw or calcMw(data.fm.I, data.fm.L, calcS(data.fm.caliber))
	if data.warhead ~= nil then
		data.warhead.caliber = data.fm.caliber * 1000 --mm
	end
	
    if data.launcher ~= nil then
	    if data.launcher.ammunition_name ~= nil then
		   data.launcher.ammunition = weapons_table.weapons.bombs[data.launcher.ammunition_name]
		end 
	end
	
	-- Arming vane activated by incoming air mass. Disabled by default.
	if data.arming_vane == nil then
		data.arming_vane = {enabled = false, velK = 1}
	end
	
	-- Arming delay timer. Enabled by default.
	if data.arming_delay == nil then
		data.arming_delay = {enabled = true, delay_time = 0.8}
	end
		
    res.server = {}
    res.client = {}
    
    copy_recursive_with_metatables(res.server, data)
    copy_recursive_with_metatables(res.client, data)
	
	res.server.scheme = "schemes/bombs/"..scheme..".sch"
    res.client.scheme = "schemes/bombs/"..scheme..".sch"
	
    if data.warhead ~= nil then 
        res.server.warhead.fantom = 0
        res.client.warhead.fantom = 1
    end
    
	if data.launcher ~= nil then
        res.server.launcher.server = 1
        res.client.launcher.server = 0
    end

    res.mass 		   = data.fm.mass
    res.name 		   = name
	res.display_name   = user_name
    res.type_name      = "bomb"
	res.targeting_data = targeting_data

	if not res.sounderName then 
		res.sounderName = "Weapons/Bomb"
	end
    return res;
end

function declare_bomb(name, user_name, model, level3, scheme, data, targeting_data, class_name, wstype_name)
	
	local res = form_bomb(name, user_name, model, level3, scheme, data, targeting_data, class_name, wstype_name)
	
	weapons_table.weapons.bombs[res.name] = res
    register_targeting_data(res.name, res.ws_type,res.targeting_data);
    
    return res;
end

function register_targeting_data(name, wstype, targeting_data)
    local res = dbtype("wBombSightData", 
    {
        ws_type = wstype;
    });
    
    copy_recursive(res, targeting_data);
    
    weapons_table.weapons.bombs.targeting[name] = res;
end


function declare_cluster(name, level3, data)
    local res = cluster_desc(name, level3, data)    
	
    weapons_table.weapons.bombs[name] = res
    
    return res;
end

DC3A4 =
{
	category  		= CAT_BOMBS,
	name      		= "DC3A4",
	model     		= "TYPEA4",
	user_name 		= _("A4 Containers"),
	wsTypeOfWeapon  = {wsType_Weapon, wsType_Bomb, wsType_Bomb_Lighter, WSTYPE_PLACEHOLDER},
	scheme    		=  "bomb-light",
	class_name		= "wAmmunitionBallute",         --  "wAmmunition_viHeavyObject",
	  type    = 2,         --    2,
        mass    = 756,
        hMin    = 150.0,
        hMax    = 7000.0,
        Cx      = 0.0001,
        VyHold  = -10.0,
        Ag      = -5.0,
       
	fm = {
            mass            = 126, --15
            caliber         = 0.7620000,
            cx_coeff        = {1.000000, 0.320000, 0.710000, 0.150000, 1.280000},
			cx_factor   	= 100,
            L               = 0.762,
            I               = 33.282267,
            Ma              = 2.746331,
            Mw              = 2.146083,
            wind_time       = 1000.000000,
            wind_sigma      = 50.000000,
    },
    
     light =
    {
	
        start_time  = 1200, --2
        duration    = 10, --300
        light_position = {0.7, 0, 0},
        light_color = {1, 1, 0.8},
        light_attenuation = 750.0,
        smoke_position = {-0.7, 0, 0},
        smoke_color = {0.952, 0.952, 0.952},
        smoke_transparency = 200.0/255.0,
        smoke_width = 1, --1
		
    },
  
    control = 
    {
        delay_par   = 2.5,
    },
	 --warhead = warheads("LUU_2B"),
	 
	 
   	shape_table_data =
	{
		{
			file     = "TYPEA4",
			index    = WSTYPE_PLACEHOLDER,
		},
	},
	targeting_data = 
	{	
    v0 = 200,
    data = 
    {
        {1.000000, 22.341401, 0.012462},
        {10.000000, 23.654340, 0.004693},
        {20.000000, 23.716158, 0.004518},
        {30.000000, 23.725884, 0.004449},
        {40.000000, 23.732343, 0.004403},
        {50.000000, 25.652849, 0.005138},
        {60.000000, 28.211796, -0.007471},
        {70.000000, 30.331842, -0.018103},
        {80.000000, 32.099833, -0.026828},
        {90.000000, 33.604543, -0.034071},
        {100.000000, 34.906022, -0.040211},
        {200.000000, 42.507192, -0.072484},
        {300.000000, 46.094889, -0.083853},
        {400.000000, 48.152369, -0.088149},
        {500.000000, 49.443189, -0.089688},
        {600.000000, 50.312083, -0.090209},
        {700.000000, 50.938257, -0.090435},
        {800.000000, 51.421467, -0.090658},
        {900.000000, 51.819370, -0.090982},
        {1000.000000, 52.166176, -0.091431},
        {1100.000000, 52.482557, -0.091997},
        {1200.000000, 52.781163, -0.092664},
        {1300.000000, 53.069819, -0.093412},
        {1400.000000, 53.353402, -0.094223},
        {1500.000000, 53.634970, -0.095085},
        {1600.000000, 53.916446, -0.095986},
        {1700.000000, 54.199051, -0.096918},
        {1800.000000, 54.483559, -0.097876},
        {1900.000000, 54.770471, -0.098855},
        {2000.000000, 55.060114, -0.099854},
        {3000.000000, 58.135449, -0.110652},
        {4000.000000, 61.578307, -0.122891},
        {5000.000000, 65.441641, -0.136735},
        {6000.000000, 69.785758, -0.152402},
        {7000.000000, 74.680457, -0.170127},
        {8000.000000, 80.206119, -0.190171},
        {9000.000000, 86.456436, -0.212829},
        {10000.000000, 93.539509, -0.164750},
 
		}    
	},
}
declare_weapon(DC3A4)

declare_loadout({
	category 		= CAT_BOMBS,
	CLSID	 		= "{DC3A4}",
	attribute		= DC3A4.wsTypeOfWeapon,
	Count 			= 6,
	Cx_pil			= DC3A4.Cx,
	Picture			= "PARABOX.png",
	displayName		= DC3A4.user_name,
	Weight			= DC3A4.mass,
	Elements  		= {{ShapeName = DC3A4.model}},
})

DC3A4SMK =
{
	category  		= CAT_BOMBS,
	name      		= "DC3A4SMK",
	model     		= "TYPEA4",
	user_name 		= _("A4 Containers with smoke"),
	wsTypeOfWeapon  = {wsType_Weapon, wsType_Bomb, wsType_Bomb_Lighter, WSTYPE_PLACEHOLDER},
	scheme    		=  "bomb-light",
	class_name		= "wAmmunitionBallute",         --  "wAmmunition_viHeavyObject",
	  type    = 2,         --    2,
        mass    = 600,
        hMin    = 150.0,
        hMax    = 7000.0,
        Cx      = 0.0001,
        VyHold  = -10.0,
        Ag      = -5.0,
       
	fm = {
            mass            = 126, --15
            caliber         = 0.7620000,
            cx_coeff        = {1.000000, 0.320000, 0.710000, 0.150000, 1.280000},
			cx_factor   	= 100,
            L               = 0.762,
            I               = 33.282267,
            Ma              = 2.746331,
            Mw              = 2.146083,
            wind_time       = 1000.000000,
            wind_sigma      = 50.000000,
    },
    
     light =
    {
	
        start_time  = 2, --2
        duration    = 360, --300
        light_position = {0.7, 0, 0},
        light_color = {1, 1, 0.8},
        light_attenuation = 750.0,
        smoke_position = {-0.7, 0, 0},
        smoke_color = {0.952, 0.952, 0.952},
        smoke_transparency = 200.0/255.0,
        smoke_width = 1, --1
		
    },
  
    control = 
    {
        delay_par   = 2.5,
    },
	 --warhead = warheads("LUU_2B"),
	 
	 
   	shape_table_data =
	{
		{
			file     = "TYPEA4",
			index    = WSTYPE_PLACEHOLDER,
		},
	},
	targeting_data = 
	{	
    v0 = 200,
    data = 
    {
        {1.000000, 22.341401, 0.012462},
        {10.000000, 23.654340, 0.004693},
        {20.000000, 23.716158, 0.004518},
        {30.000000, 23.725884, 0.004449},
        {40.000000, 23.732343, 0.004403},
        {50.000000, 25.652849, 0.005138},
        {60.000000, 28.211796, -0.007471},
        {70.000000, 30.331842, -0.018103},
        {80.000000, 32.099833, -0.026828},
        {90.000000, 33.604543, -0.034071},
        {100.000000, 34.906022, -0.040211},
        {200.000000, 42.507192, -0.072484},
        {300.000000, 46.094889, -0.083853},
        {400.000000, 48.152369, -0.088149},
        {500.000000, 49.443189, -0.089688},
        {600.000000, 50.312083, -0.090209},
        {700.000000, 50.938257, -0.090435},
        {800.000000, 51.421467, -0.090658},
        {900.000000, 51.819370, -0.090982},
        {1000.000000, 52.166176, -0.091431},
        {1100.000000, 52.482557, -0.091997},
        {1200.000000, 52.781163, -0.092664},
        {1300.000000, 53.069819, -0.093412},
        {1400.000000, 53.353402, -0.094223},
        {1500.000000, 53.634970, -0.095085},
        {1600.000000, 53.916446, -0.095986},
        {1700.000000, 54.199051, -0.096918},
        {1800.000000, 54.483559, -0.097876},
        {1900.000000, 54.770471, -0.098855},
        {2000.000000, 55.060114, -0.099854},
        {3000.000000, 58.135449, -0.110652},
        {4000.000000, 61.578307, -0.122891},
        {5000.000000, 65.441641, -0.136735},
        {6000.000000, 69.785758, -0.152402},
        {7000.000000, 74.680457, -0.170127},
        {8000.000000, 80.206119, -0.190171},
        {9000.000000, 86.456436, -0.212829},
        {10000.000000, 93.539509, -0.164750},
 
		}    
	},
}
declare_weapon(DC3A4SMK)

declare_loadout({
	category 		= CAT_BOMBS,
	CLSID	 		= "{DC3A4SMK}",
	attribute		= DC3A4SMK.wsTypeOfWeapon,
	Count 			= 6,
	Cx_pil			= DC3A4SMK.Cx,
	Picture			= "PARABOX.png",
	displayName		= DC3A4SMK.user_name,
	Weight			= DC3A4SMK.mass,
	Elements  		= {{ShapeName = DC3A4SMK.model}},
})

DC3A5EQP =
{
	category  		= CAT_BOMBS,
	name      		= "DC3A5EQP",
	model     		= "TYPEA5EQP",
	user_name 		= _("A5 Equipment Containers"),
	wsTypeOfWeapon  = {wsType_Weapon, wsType_Bomb, wsType_Bomb_Lighter, WSTYPE_PLACEHOLDER},
	scheme    		=  "bomb-light",
	class_name		= "wAmmunitionBallute",         --  "wAmmunition_viHeavyObject",
	  type    = 2,         --    2,
        mass    = 756,
        hMin    = 150.0,
        hMax    = 7000.0,
        Cx      = 0.0001,
        VyHold  = -10.0,
        Ag      = -5.0,
       
	fm = {
            mass            = 126, --15
            caliber         = 1.4224,
            cx_coeff        = {1.000000, 0.320000, 0.710000, 0.150000, 1.280000},
			cx_factor   	= 100,
            L               = 1.4224,
            I               = 33.282267,
            Ma              = 2.746331,
            Mw              = 2.146083,
            wind_time       = 1000.000000,
            wind_sigma      = 50.000000,
    },
    
     light =
    {
	
        start_time  = 1200, --2
        duration    = 10, --300
        light_position = {0.7, 0, 0},
        light_color = {1, 1, 0.8},
        light_attenuation = 750.0,
        smoke_position = {-0.7, 0, 0},
        smoke_color = {0.952, 0.952, 0.952},
        smoke_transparency = 200.0/255.0,
        smoke_width = 1, --1
		
    },
  
    control = 
    {
        delay_par   = 2.5,
    },
	 --warhead = warheads("LUU_2B"),
	 
	 
   	shape_table_data =
	{
		{
			file     = "TYPEA5EQP",
			index    = WSTYPE_PLACEHOLDER,
		},
	},
	targeting_data = 
	{	
    v0 = 200,
    data = 
    {
        {1.000000, 22.341401, 0.012462},
        {10.000000, 23.654340, 0.004693},
        {20.000000, 23.716158, 0.004518},
        {30.000000, 23.725884, 0.004449},
        {40.000000, 23.732343, 0.004403},
        {50.000000, 25.652849, 0.005138},
        {60.000000, 28.211796, -0.007471},
        {70.000000, 30.331842, -0.018103},
        {80.000000, 32.099833, -0.026828},
        {90.000000, 33.604543, -0.034071},
        {100.000000, 34.906022, -0.040211},
        {200.000000, 42.507192, -0.072484},
        {300.000000, 46.094889, -0.083853},
        {400.000000, 48.152369, -0.088149},
        {500.000000, 49.443189, -0.089688},
        {600.000000, 50.312083, -0.090209},
        {700.000000, 50.938257, -0.090435},
        {800.000000, 51.421467, -0.090658},
        {900.000000, 51.819370, -0.090982},
        {1000.000000, 52.166176, -0.091431},
        {1100.000000, 52.482557, -0.091997},
        {1200.000000, 52.781163, -0.092664},
        {1300.000000, 53.069819, -0.093412},
        {1400.000000, 53.353402, -0.094223},
        {1500.000000, 53.634970, -0.095085},
        {1600.000000, 53.916446, -0.095986},
        {1700.000000, 54.199051, -0.096918},
        {1800.000000, 54.483559, -0.097876},
        {1900.000000, 54.770471, -0.098855},
        {2000.000000, 55.060114, -0.099854},
        {3000.000000, 58.135449, -0.110652},
        {4000.000000, 61.578307, -0.122891},
        {5000.000000, 65.441641, -0.136735},
        {6000.000000, 69.785758, -0.152402},
        {7000.000000, 74.680457, -0.170127},
        {8000.000000, 80.206119, -0.190171},
        {9000.000000, 86.456436, -0.212829},
        {10000.000000, 93.539509, -0.164750},
 
		}    
	},
}
declare_weapon(DC3A5EQP)

declare_loadout({
	category 		= CAT_BOMBS,
	CLSID	 		= "DC3A5EQP",
	attribute		= DC3A5EQP.wsTypeOfWeapon,
	Count 			= 6,
	Cx_pil			= DC3A5EQP.Cx,
	Picture			= "PARABOX.png",
	displayName		= DC3A5EQP.user_name,
	Weight			= DC3A5EQP.mass,
	Elements  		= {{ShapeName = DC3A5EQP.model}},
})

DC3A5EQPS =
{
	category  		= CAT_BOMBS,
	name      		= "DC3A5EQPS",
	model     		= "TYPEA5EQP",
	user_name 		= _("A5 Equipment Containers with smoke"),
	wsTypeOfWeapon  = {wsType_Weapon, wsType_Bomb, wsType_Bomb_Lighter, WSTYPE_PLACEHOLDER},
	scheme    		=  "bomb-light",
	class_name		= "wAmmunitionBallute",         --  "wAmmunition_viHeavyObject",
	  type    = 2,         --    2,
        mass    = 756,
        hMin    = 150.0,
        hMax    = 7000.0,
        Cx      = 0.0001,
        VyHold  = -10.0,
        Ag      = -5.0,
       
	fm = {
            mass            = 126, --15
            caliber         = 1.4224,
            cx_coeff        = {1.000000, 0.320000, 0.710000, 0.150000, 1.280000},
			cx_factor   	= 100,
            L               = 1.4224,
            I               = 33.282267,
            Ma              = 2.746331,
            Mw              = 2.146083,
            wind_time       = 1000.000000,
            wind_sigma      = 50.000000,
    },
    
     light =
    {
	
        start_time  = 3, --2
        duration    = 360, --300
        light_position = {0.7, 0, 0},
        light_color = {1, 1, 0.8},
        light_attenuation = 750.0,
        smoke_position = {-0.7, 0, 0},
        smoke_color = {0.952, 0.952, 0.952},
        smoke_transparency = 200.0/255.0,
        smoke_width = 1, --1
		
    },
  
    control = 
    {
        delay_par   = 2.5,
    },
	 --warhead = warheads("LUU_2B"),
	 
	 
   	shape_table_data =
	{
		{
			file     = "TYPEA5EQP",
			index    = WSTYPE_PLACEHOLDER,
		},
	},
	targeting_data = 
	{	
    v0 = 200,
    data = 
    {
        {1.000000, 22.341401, 0.012462},
        {10.000000, 23.654340, 0.004693},
        {20.000000, 23.716158, 0.004518},
        {30.000000, 23.725884, 0.004449},
        {40.000000, 23.732343, 0.004403},
        {50.000000, 25.652849, 0.005138},
        {60.000000, 28.211796, -0.007471},
        {70.000000, 30.331842, -0.018103},
        {80.000000, 32.099833, -0.026828},
        {90.000000, 33.604543, -0.034071},
        {100.000000, 34.906022, -0.040211},
        {200.000000, 42.507192, -0.072484},
        {300.000000, 46.094889, -0.083853},
        {400.000000, 48.152369, -0.088149},
        {500.000000, 49.443189, -0.089688},
        {600.000000, 50.312083, -0.090209},
        {700.000000, 50.938257, -0.090435},
        {800.000000, 51.421467, -0.090658},
        {900.000000, 51.819370, -0.090982},
        {1000.000000, 52.166176, -0.091431},
        {1100.000000, 52.482557, -0.091997},
        {1200.000000, 52.781163, -0.092664},
        {1300.000000, 53.069819, -0.093412},
        {1400.000000, 53.353402, -0.094223},
        {1500.000000, 53.634970, -0.095085},
        {1600.000000, 53.916446, -0.095986},
        {1700.000000, 54.199051, -0.096918},
        {1800.000000, 54.483559, -0.097876},
        {1900.000000, 54.770471, -0.098855},
        {2000.000000, 55.060114, -0.099854},
        {3000.000000, 58.135449, -0.110652},
        {4000.000000, 61.578307, -0.122891},
        {5000.000000, 65.441641, -0.136735},
        {6000.000000, 69.785758, -0.152402},
        {7000.000000, 74.680457, -0.170127},
        {8000.000000, 80.206119, -0.190171},
        {9000.000000, 86.456436, -0.212829},
        {10000.000000, 93.539509, -0.164750},
 
		}    
	},
}
declare_weapon(DC3A5EQPS)

declare_loadout({
	category 		= CAT_BOMBS,
	CLSID	 		= "{DC3A5EQPS}",
	attribute		= DC3A5EQPS.wsTypeOfWeapon,
	Count 			= 6,
	Cx_pil			= DC3A5EQPS.Cx,
	Picture			= "PARABOX.png",
	displayName		= DC3A5EQPS.user_name,
	Weight			= DC3A5EQPS.mass,
	Elements  		= {{ShapeName = DC3A5EQPS.model}},
})

DC3A5MED =
{
	category  		= CAT_BOMBS,
	name      		= "DC3A5MED",
	model     		= "TYPEA5MED",
	user_name 		= _("A5 Medical Containers"),
	wsTypeOfWeapon  = {wsType_Weapon, wsType_Bomb, wsType_Bomb_Lighter, WSTYPE_PLACEHOLDER},
	scheme    		=  "bomb-light",
	class_name		= "wAmmunitionBallute",         --  "wAmmunition_viHeavyObject",
	  type    = 2,         --    2,
        mass    = 756,
        hMin    = 150.0,
        hMax    = 7000.0,
        Cx      = 0.0001,
        VyHold  = -10.0,
        Ag      = -5.0,
       
	fm = {
            mass            = 126, --15
            caliber         = 1.4224,
            cx_coeff        = {1.000000, 0.320000, 0.710000, 0.150000, 1.280000},
			cx_factor   	= 100,
            L               = 1.4224,
            I               = 33.282267,
            Ma              = 2.746331,
            Mw              = 2.146083,
            wind_time       = 1000.000000,
            wind_sigma      = 50.000000,
    },
    
     light =
    {
	
        start_time  = 1200, --2
        duration    = 10, --300
        light_position = {0.7, 0, 0},
        light_color = {1, 1, 0.8},
        light_attenuation = 750.0,
        smoke_position = {-0.7, 0, 0},
        smoke_color = {0.952, 0.952, 0.952},
        smoke_transparency = 200.0/255.0,
        smoke_width = 1, --1
		
    },
  
    control = 
    {
        delay_par   = 2.5,
    },
	 --warhead = warheads("LUU_2B"),
	 
	 
   	shape_table_data =
	{
		{
			file     = "TYPEA5MED",
			index    = WSTYPE_PLACEHOLDER,
		},
	},
	targeting_data = 
	{	
    v0 = 200,
    data = 
    {
        {1.000000, 22.341401, 0.012462},
        {10.000000, 23.654340, 0.004693},
        {20.000000, 23.716158, 0.004518},
        {30.000000, 23.725884, 0.004449},
        {40.000000, 23.732343, 0.004403},
        {50.000000, 25.652849, 0.005138},
        {60.000000, 28.211796, -0.007471},
        {70.000000, 30.331842, -0.018103},
        {80.000000, 32.099833, -0.026828},
        {90.000000, 33.604543, -0.034071},
        {100.000000, 34.906022, -0.040211},
        {200.000000, 42.507192, -0.072484},
        {300.000000, 46.094889, -0.083853},
        {400.000000, 48.152369, -0.088149},
        {500.000000, 49.443189, -0.089688},
        {600.000000, 50.312083, -0.090209},
        {700.000000, 50.938257, -0.090435},
        {800.000000, 51.421467, -0.090658},
        {900.000000, 51.819370, -0.090982},
        {1000.000000, 52.166176, -0.091431},
        {1100.000000, 52.482557, -0.091997},
        {1200.000000, 52.781163, -0.092664},
        {1300.000000, 53.069819, -0.093412},
        {1400.000000, 53.353402, -0.094223},
        {1500.000000, 53.634970, -0.095085},
        {1600.000000, 53.916446, -0.095986},
        {1700.000000, 54.199051, -0.096918},
        {1800.000000, 54.483559, -0.097876},
        {1900.000000, 54.770471, -0.098855},
        {2000.000000, 55.060114, -0.099854},
        {3000.000000, 58.135449, -0.110652},
        {4000.000000, 61.578307, -0.122891},
        {5000.000000, 65.441641, -0.136735},
        {6000.000000, 69.785758, -0.152402},
        {7000.000000, 74.680457, -0.170127},
        {8000.000000, 80.206119, -0.190171},
        {9000.000000, 86.456436, -0.212829},
        {10000.000000, 93.539509, -0.164750},
 
		}    
	},
}
declare_weapon(DC3A5MED)

declare_loadout({
	category 		= CAT_BOMBS,
	CLSID	 		= "DC3A5MED",
	attribute		= DC3A5MED.wsTypeOfWeapon,
	Count 			= 6,
	Cx_pil			= DC3A5MED.Cx,
	Picture			= "PARABOX.png",
	displayName		= DC3A5MED.user_name,
	Weight			= DC3A5MED.mass,
	Elements  		= {{ShapeName = DC3A5MED.model}},
})

DC3A5MEDS =
{
	category  		= CAT_BOMBS,
	name      		= "DC3A5MEDS",
	model     		= "TYPEA5MED",
	user_name 		= _("A5 Medical Containers with smoke"),
	wsTypeOfWeapon  = {wsType_Weapon, wsType_Bomb, wsType_Bomb_Lighter, WSTYPE_PLACEHOLDER},
	scheme    		=  "bomb-light",
	class_name		= "wAmmunitionBallute",         --  "wAmmunition_viHeavyObject",
	  type    = 2,         --    2,
        mass    = 756,
        hMin    = 150.0,
        hMax    = 7000.0,
        Cx      = 0.0001,
        VyHold  = -10.0,
        Ag      = -5.0,
       
	fm = {
            mass            = 126, --15
            caliber         = 1.4224,
            cx_coeff        = {1.000000, 0.320000, 0.710000, 0.150000, 1.280000},
			cx_factor   	= 100,
            L               = 1.4224,
            I               = 33.282267,
            Ma              = 2.746331,
            Mw              = 2.146083,
            wind_time       = 1000.000000,
            wind_sigma      = 50.000000,
    },
    
     light =
    {
	
        start_time  = 3, --2
        duration    = 360, --300
        light_position = {0.7, 0, 0},
        light_color = {1, 1, 0.8},
        light_attenuation = 750.0,
        smoke_position = {-0.7, 0, 0},
        smoke_color = {0.952, 0.952, 0.952},
        smoke_transparency = 200.0/255.0,
        smoke_width = 1, --1
		
    },
  
    control = 
    {
        delay_par   = 2.5,
    },
	 --warhead = warheads("LUU_2B"),
	 
	 
   	shape_table_data =
	{
		{
			file     = "TYPEA5MED",
			index    = WSTYPE_PLACEHOLDER,
		},
	},
	targeting_data = 
	{	
    v0 = 200,
    data = 
    {
        {1.000000, 22.341401, 0.012462},
        {10.000000, 23.654340, 0.004693},
        {20.000000, 23.716158, 0.004518},
        {30.000000, 23.725884, 0.004449},
        {40.000000, 23.732343, 0.004403},
        {50.000000, 25.652849, 0.005138},
        {60.000000, 28.211796, -0.007471},
        {70.000000, 30.331842, -0.018103},
        {80.000000, 32.099833, -0.026828},
        {90.000000, 33.604543, -0.034071},
        {100.000000, 34.906022, -0.040211},
        {200.000000, 42.507192, -0.072484},
        {300.000000, 46.094889, -0.083853},
        {400.000000, 48.152369, -0.088149},
        {500.000000, 49.443189, -0.089688},
        {600.000000, 50.312083, -0.090209},
        {700.000000, 50.938257, -0.090435},
        {800.000000, 51.421467, -0.090658},
        {900.000000, 51.819370, -0.090982},
        {1000.000000, 52.166176, -0.091431},
        {1100.000000, 52.482557, -0.091997},
        {1200.000000, 52.781163, -0.092664},
        {1300.000000, 53.069819, -0.093412},
        {1400.000000, 53.353402, -0.094223},
        {1500.000000, 53.634970, -0.095085},
        {1600.000000, 53.916446, -0.095986},
        {1700.000000, 54.199051, -0.096918},
        {1800.000000, 54.483559, -0.097876},
        {1900.000000, 54.770471, -0.098855},
        {2000.000000, 55.060114, -0.099854},
        {3000.000000, 58.135449, -0.110652},
        {4000.000000, 61.578307, -0.122891},
        {5000.000000, 65.441641, -0.136735},
        {6000.000000, 69.785758, -0.152402},
        {7000.000000, 74.680457, -0.170127},
        {8000.000000, 80.206119, -0.190171},
        {9000.000000, 86.456436, -0.212829},
        {10000.000000, 93.539509, -0.164750},
 
		}    
	},
}
declare_weapon(DC3A5MEDS)

declare_loadout({
	category 		= CAT_BOMBS,
	CLSID	 		= "DC3A5MEDS",
	attribute		= DC3A5MEDS.wsTypeOfWeapon,
	Count 			= 6,
	Cx_pil			= DC3A5MEDS.Cx,
	Picture			= "PARABOX.png",
	displayName		= DC3A5MEDS.user_name,
	Weight			= DC3A5MEDS.mass,
	Elements  		= {{ShapeName = DC3A5MEDS.model}},
})

DC3A5AMO =
{
	category  		= CAT_BOMBS,
	name      		= "DC3A5AMO",
	model     		= "TYPEA5AMO",
	user_name 		= _("A5 Ammo Containers"),
	wsTypeOfWeapon  = {wsType_Weapon, wsType_Bomb, wsType_Bomb_Lighter, WSTYPE_PLACEHOLDER},
	scheme    		=  "bomb-light",
	class_name		= "wAmmunitionBallute",         --  "wAmmunition_viHeavyObject",
	  type    = 2,         --    2,
        mass    = 756,
        hMin    = 150.0,
        hMax    = 7000.0,
        Cx      = 0.0001,
        VyHold  = -10.0,
        Ag      = -5.0,
       
	fm = {
            mass            = 126, --15
            caliber         = 1.4224,
            cx_coeff        = {1.000000, 0.320000, 0.710000, 0.150000, 1.280000},
			cx_factor   	= 100,
            L               = 1.4224,
            I               = 33.282267,
            Ma              = 2.746331,
            Mw              = 2.146083,
            wind_time       = 1000.000000,
            wind_sigma      = 50.000000,
    },
    
     light =
    {
	
        start_time  = 1200, --2
        duration    = 10, --300
        light_position = {0.7, 0, 0},
        light_color = {1, 1, 0.8},
        light_attenuation = 750.0,
        smoke_position = {-0.7, 0, 0},
        smoke_color = {0.952, 0.952, 0.952},
        smoke_transparency = 200.0/255.0,
        smoke_width = 1, --1
		
    },
  
    control = 
    {
        delay_par   = 2.5,
    },
	 --warhead = warheads("LUU_2B"),
	 
	 
   	shape_table_data =
	{
		{
			file     = "TYPEA5AMO",
			index    = WSTYPE_PLACEHOLDER,
		},
	},
	targeting_data = 
	{	
    v0 = 200,
    data = 
    {
        {1.000000, 22.341401, 0.012462},
        {10.000000, 23.654340, 0.004693},
        {20.000000, 23.716158, 0.004518},
        {30.000000, 23.725884, 0.004449},
        {40.000000, 23.732343, 0.004403},
        {50.000000, 25.652849, 0.005138},
        {60.000000, 28.211796, -0.007471},
        {70.000000, 30.331842, -0.018103},
        {80.000000, 32.099833, -0.026828},
        {90.000000, 33.604543, -0.034071},
        {100.000000, 34.906022, -0.040211},
        {200.000000, 42.507192, -0.072484},
        {300.000000, 46.094889, -0.083853},
        {400.000000, 48.152369, -0.088149},
        {500.000000, 49.443189, -0.089688},
        {600.000000, 50.312083, -0.090209},
        {700.000000, 50.938257, -0.090435},
        {800.000000, 51.421467, -0.090658},
        {900.000000, 51.819370, -0.090982},
        {1000.000000, 52.166176, -0.091431},
        {1100.000000, 52.482557, -0.091997},
        {1200.000000, 52.781163, -0.092664},
        {1300.000000, 53.069819, -0.093412},
        {1400.000000, 53.353402, -0.094223},
        {1500.000000, 53.634970, -0.095085},
        {1600.000000, 53.916446, -0.095986},
        {1700.000000, 54.199051, -0.096918},
        {1800.000000, 54.483559, -0.097876},
        {1900.000000, 54.770471, -0.098855},
        {2000.000000, 55.060114, -0.099854},
        {3000.000000, 58.135449, -0.110652},
        {4000.000000, 61.578307, -0.122891},
        {5000.000000, 65.441641, -0.136735},
        {6000.000000, 69.785758, -0.152402},
        {7000.000000, 74.680457, -0.170127},
        {8000.000000, 80.206119, -0.190171},
        {9000.000000, 86.456436, -0.212829},
        {10000.000000, 93.539509, -0.164750},
 
		}    
	},
}
declare_weapon(DC3A5AMO)

declare_loadout({
	category 		= CAT_BOMBS,
	CLSID	 		= "DC3A5AMO",
	attribute		= DC3A5AMO.wsTypeOfWeapon,
	Count 			= 6,
	Cx_pil			= DC3A5AMO.Cx,
	Picture			= "PARABOX.png",
	displayName		= DC3A5AMO.user_name,
	Weight			= DC3A5AMO.mass,
	Elements  		= {{ShapeName = DC3A5AMO.model}},
})

DC3A5AMOS =
{
	category  		= CAT_BOMBS,
	name      		= "DC3A5AMOS",
	model     		= "TYPEA5AMOS",
	user_name 		= _("A5 Ammo Containers with smoke"),
	wsTypeOfWeapon  = {wsType_Weapon, wsType_Bomb, wsType_Bomb_Lighter, WSTYPE_PLACEHOLDER},
	scheme    		=  "bomb-light",
	class_name		= "wAmmunitionBallute",         --  "wAmmunition_viHeavyObject",
	  type    = 2,         --    2,
        mass    = 756,
        hMin    = 150.0,
        hMax    = 7000.0,
        Cx      = 0.0001,
        VyHold  = -10.0,
        Ag      = -5.0,
       
	fm = {
            mass            = 126, --15
            caliber         = 1.4224,
            cx_coeff        = {1.000000, 0.320000, 0.710000, 0.150000, 1.280000},
			cx_factor   	= 100,
            L               = 1.4224,
            I               = 33.282267,
            Ma              = 2.746331,
            Mw              = 2.146083,
            wind_time       = 1000.000000,
            wind_sigma      = 50.000000,
    },
    
     light =
    {
	
        start_time  = 3, --2
        duration    = 360, --300
        light_position = {0.7, 0, 0},
        light_color = {1, 1, 0.8},
        light_attenuation = 750.0,
        smoke_position = {-0.7, 0, 0},
        smoke_color = {0.952, 0.952, 0.952},
        smoke_transparency = 200.0/255.0,
        smoke_width = 1, --1
		
    },
  
    control = 
    {
        delay_par   = 2.5,
    },
	 --warhead = warheads("LUU_2B"),
	 
	 
   	shape_table_data =
	{
		{
			file     = "TYPEA5AMO",
			index    = WSTYPE_PLACEHOLDER,
		},
	},
	targeting_data = 
	{	
    v0 = 200,
    data = 
    {
        {1.000000, 22.341401, 0.012462},
        {10.000000, 23.654340, 0.004693},
        {20.000000, 23.716158, 0.004518},
        {30.000000, 23.725884, 0.004449},
        {40.000000, 23.732343, 0.004403},
        {50.000000, 25.652849, 0.005138},
        {60.000000, 28.211796, -0.007471},
        {70.000000, 30.331842, -0.018103},
        {80.000000, 32.099833, -0.026828},
        {90.000000, 33.604543, -0.034071},
        {100.000000, 34.906022, -0.040211},
        {200.000000, 42.507192, -0.072484},
        {300.000000, 46.094889, -0.083853},
        {400.000000, 48.152369, -0.088149},
        {500.000000, 49.443189, -0.089688},
        {600.000000, 50.312083, -0.090209},
        {700.000000, 50.938257, -0.090435},
        {800.000000, 51.421467, -0.090658},
        {900.000000, 51.819370, -0.090982},
        {1000.000000, 52.166176, -0.091431},
        {1100.000000, 52.482557, -0.091997},
        {1200.000000, 52.781163, -0.092664},
        {1300.000000, 53.069819, -0.093412},
        {1400.000000, 53.353402, -0.094223},
        {1500.000000, 53.634970, -0.095085},
        {1600.000000, 53.916446, -0.095986},
        {1700.000000, 54.199051, -0.096918},
        {1800.000000, 54.483559, -0.097876},
        {1900.000000, 54.770471, -0.098855},
        {2000.000000, 55.060114, -0.099854},
        {3000.000000, 58.135449, -0.110652},
        {4000.000000, 61.578307, -0.122891},
        {5000.000000, 65.441641, -0.136735},
        {6000.000000, 69.785758, -0.152402},
        {7000.000000, 74.680457, -0.170127},
        {8000.000000, 80.206119, -0.190171},
        {9000.000000, 86.456436, -0.212829},
        {10000.000000, 93.539509, -0.164750},
 
		}    
	},
}
declare_weapon(DC3A5AMOS)

declare_loadout({
	category 		= CAT_BOMBS,
	CLSID	 		= "DC3A5AMOS",
	attribute		= DC3A5AMOS.wsTypeOfWeapon,
	Count 			= 6,
	Cx_pil			= DC3A5AMOS.Cx,
	Picture			= "PARABOX.png",
	displayName		= DC3A5AMOS.user_name,
	Weight			= DC3A5AMOS.mass,
	Elements  		= {{ShapeName = DC3A5AMOS.model}},
})

DC3BOX =
{
	category  		= CAT_BOMBS,
	name      		= "DC3BOX",
	model     		= "AIRBORNE_BOX",
	user_name 		= _("Supplies"),
	wsTypeOfWeapon  = {wsType_Weapon, wsType_Bomb, wsType_Bomb_Lighter, WSTYPE_PLACEHOLDER},
	scheme    		=  "bomb-light",
	class_name		= "wAmmunitionBallute",         --  "wAmmunition_viHeavyObject",
	  type    = 2,         --    2,
        mass    = 900,
        hMin    = 150.0,
        hMax    = 7000.0,
        Cx      = 0.0001,
        VyHold  = -10.0,
        Ag      = -5.0,
       
	fm = {
            mass            = 126, --15
            caliber         = 0.2730000,
            cx_coeff        = {1.000000, 0.320000, 0.710000, 0.150000, 1.280000},
			cx_factor   	= 100,
            L               = 1.05,
            I               = 33.282267,
            Ma              = 2.746331,
            Mw              = 2.146083,
            wind_time       = 1000.000000,
            wind_sigma      = 50.000000,
    },
    
     light =
    {
	
        start_time  = 1200, --2
        duration    = 10, --300
        light_position = {0.7, 0, 0},
        light_color = {1, 1, 0.8},
        light_attenuation = 750.0,
        smoke_position = {-0.7, 0, 0},
        smoke_color = {0.952, 0.952, 0.952},
        smoke_transparency = 200.0/255.0,
        smoke_width = 1, --1
		
    },
  
    control = 
    {
        delay_par   = 2.5,
    },
	 --warhead = warheads("LUU_2B"),
	 
	 
   	shape_table_data =
	{
		{
			file     = "AIRBORNE_BOX",
			index    = WSTYPE_PLACEHOLDER,
		},
	},
	targeting_data = 
	{	
    v0 = 200,
    data = 
    {
        {1.000000, 22.341401, 0.012462},
        {10.000000, 23.654340, 0.004693},
        {20.000000, 23.716158, 0.004518},
        {30.000000, 23.725884, 0.004449},
        {40.000000, 23.732343, 0.004403},
        {50.000000, 25.652849, 0.005138},
        {60.000000, 28.211796, -0.007471},
        {70.000000, 30.331842, -0.018103},
        {80.000000, 32.099833, -0.026828},
        {90.000000, 33.604543, -0.034071},
        {100.000000, 34.906022, -0.040211},
        {200.000000, 42.507192, -0.072484},
        {300.000000, 46.094889, -0.083853},
        {400.000000, 48.152369, -0.088149},
        {500.000000, 49.443189, -0.089688},
        {600.000000, 50.312083, -0.090209},
        {700.000000, 50.938257, -0.090435},
        {800.000000, 51.421467, -0.090658},
        {900.000000, 51.819370, -0.090982},
        {1000.000000, 52.166176, -0.091431},
        {1100.000000, 52.482557, -0.091997},
        {1200.000000, 52.781163, -0.092664},
        {1300.000000, 53.069819, -0.093412},
        {1400.000000, 53.353402, -0.094223},
        {1500.000000, 53.634970, -0.095085},
        {1600.000000, 53.916446, -0.095986},
        {1700.000000, 54.199051, -0.096918},
        {1800.000000, 54.483559, -0.097876},
        {1900.000000, 54.770471, -0.098855},
        {2000.000000, 55.060114, -0.099854},
        {3000.000000, 58.135449, -0.110652},
        {4000.000000, 61.578307, -0.122891},
        {5000.000000, 65.441641, -0.136735},
        {6000.000000, 69.785758, -0.152402},
        {7000.000000, 74.680457, -0.170127},
        {8000.000000, 80.206119, -0.190171},
        {9000.000000, 86.456436, -0.212829},
        {10000.000000, 93.539509, -0.164750},
 
		}    
	},
}
declare_weapon(DC3BOX)


declare_loadout({
	category 		= CAT_BOMBS,
	CLSID	 		= "{DC3BOX}",
	attribute		= DC3BOX.wsTypeOfWeapon,
	Count 			= 3 ,
	Cx_pil			= DC3BOX.Cx,
	Picture			= "PARABOX.png",
	displayName		= DC3BOX.user_name,
	Weight			= DC3BOX.mass,
	Elements  		= {{ShapeName = DC3BOX.model}},
})

DC3BOXSMK =
{
	category  		= CAT_BOMBS,
	name      		= "DC3BOXSMK",
	model     		= "AIRBORNE_BOX",
	user_name 		= _("Supplies + smoke"),
	wsTypeOfWeapon  = {wsType_Weapon, wsType_Bomb, wsType_Bomb_Lighter, WSTYPE_PLACEHOLDER},
	scheme    		=  "bomb-light",
	class_name		= "wAmmunitionBallute",         --  "wAmmunition_viHeavyObject",
	  type    = 2,         --    2,
        mass    = 900,
        hMin    = 150.0,
        hMax    = 7000.0,
        Cx      = 0.0001,
        VyHold  = -10.0,
        Ag      = -5.0,
       
	fm = {
            mass            = 126, --15
            caliber         = 0.2730000,
            cx_coeff        = {1.000000, 0.320000, 0.710000, 0.150000, 1.280000},
			cx_factor   	= 100,
            L               = 1.05,
            I               = 33.282267,
            Ma              = 2.746331,
            Mw              = 2.146083,
            wind_time       = 1000.000000,
            wind_sigma      = 50.000000,
    },
    
     light =
    {
	
        start_time  = 2, --2
        duration    = 360, --300
        light_position = {0.7, 0, 0},
        light_color = {1, 1, 0.8},
        light_attenuation = 750.0,
        smoke_position = {-0.7, 0, 0},
        smoke_color = {0.952, 0.952, 0.952},
        smoke_transparency = 200.0/255.0,
        smoke_width = 1, --1
		
    },
  
    control = 
    {
        delay_par   = 2.5,
    },
	 --warhead = warheads("LUU_2B"),
	 
	 
   	shape_table_data =
	{
		{
			file     = "AIRBORNE_BOX",
			index    = WSTYPE_PLACEHOLDER,
		},
	},
	targeting_data = 
	{	
    v0 = 200,
    data = 
    {
        {1.000000, 22.341401, 0.012462},
        {10.000000, 23.654340, 0.004693},
        {20.000000, 23.716158, 0.004518},
        {30.000000, 23.725884, 0.004449},
        {40.000000, 23.732343, 0.004403},
        {50.000000, 25.652849, 0.005138},
        {60.000000, 28.211796, -0.007471},
        {70.000000, 30.331842, -0.018103},
        {80.000000, 32.099833, -0.026828},
        {90.000000, 33.604543, -0.034071},
        {100.000000, 34.906022, -0.040211},
        {200.000000, 42.507192, -0.072484},
        {300.000000, 46.094889, -0.083853},
        {400.000000, 48.152369, -0.088149},
        {500.000000, 49.443189, -0.089688},
        {600.000000, 50.312083, -0.090209},
        {700.000000, 50.938257, -0.090435},
        {800.000000, 51.421467, -0.090658},
        {900.000000, 51.819370, -0.090982},
        {1000.000000, 52.166176, -0.091431},
        {1100.000000, 52.482557, -0.091997},
        {1200.000000, 52.781163, -0.092664},
        {1300.000000, 53.069819, -0.093412},
        {1400.000000, 53.353402, -0.094223},
        {1500.000000, 53.634970, -0.095085},
        {1600.000000, 53.916446, -0.095986},
        {1700.000000, 54.199051, -0.096918},
        {1800.000000, 54.483559, -0.097876},
        {1900.000000, 54.770471, -0.098855},
        {2000.000000, 55.060114, -0.099854},
        {3000.000000, 58.135449, -0.110652},
        {4000.000000, 61.578307, -0.122891},
        {5000.000000, 65.441641, -0.136735},
        {6000.000000, 69.785758, -0.152402},
        {7000.000000, 74.680457, -0.170127},
        {8000.000000, 80.206119, -0.190171},
        {9000.000000, 86.456436, -0.212829},
        {10000.000000, 93.539509, -0.164750},
 
		}    
	},
}
declare_weapon(DC3BOXSMK)


declare_loadout({
	category 		= CAT_BOMBS,
	CLSID	 		= "{DC3BOXSMK}",
	attribute		= DC3BOXSMK.wsTypeOfWeapon,
	Count 			= 3 ,
	Cx_pil			= DC3BOXSMK.Cx,
	Picture			= "PARABOX.png",
	displayName		= DC3BOXSMK.user_name,
	Weight			= DC3BOXSMK.mass,
	Elements  		= {{ShapeName = DC3BOXSMK.model}},
})